from parallels.core import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.migrator_config import is_transfer_resource_limits_enabled
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties
from parallels.core.target_panels import TargetPanels


class RemoveSubscriptionLimitsAndPermissions(SubscriptionBackupAction):
	"""Remove limits and permissions of all subscriptions from Plesk backup file if necessary."""

	def get_description(self):
		return messages.REMOVE_LIMITS_AND_PERMISSIONS_FROM_BACKUP

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_REMOVE_LIMITS_AND_PERMISSIONS_FOR % subscription.name

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		transfer_plesk_resource_limits_enabled = (
			# Transfer resource limits with the help of backup dump only for target Plesk
			global_context.target_panel == TargetPanels.PLESK
			and 
			is_transfer_resource_limits_enabled(
				global_context.config, 
				global_context.target_panel_obj
			)
		)

		if not transfer_plesk_resource_limits_enabled:
			subscription_backup.remove_limit_and_permissions()
