from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.utils.windows_agent_pool import WindowsAgentPool


class Start(CommonAction):
	def get_description(self):
		return messages.ACTION_START_TRANSFER_AGENTS

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.ACTION_START_TRANSFER_AGENTS_FAILED

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed, migration tool won't run the next operations.

		:rtype: bool
		"""
		return True

	def run(self, global_context):
		"""
		Deploy and start transfer agent on windows source servers.

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		transfer_agent_pool = WindowsAgentPool.get_instance(global_context.migrator_server)
		for server_info in global_context.get_source_servers_info():
			if server_info.is_windows and server_info.ip is not None:
				transfer_agent_pool.get(server_info.settings)
