import logging

from parallels.core import messages
from parallels.core.converter.business_objects.common import SOURCE_TARGET

logger = logging.getLogger(__name__)


class ResellerImporter(object):
	def __init__(self, import_api, safe):
		self.safe = safe
		self.import_api = import_api

	def import_resellers(self, resellers):
		"""Import resellers stubs: only contact data, no subscription to reseller plan is created"""
		for reseller in resellers:
			with self.safe.try_reseller(
				reseller.login, messages.FAILED_TO_CREATE_RESELLER_ON_TARGET % self.import_api.system_name
			):
				if reseller.source != SOURCE_TARGET:
					logger.info(u"Create reseller '%s'", reseller.login)
					self.import_api.create_reseller(reseller)