import textwrap


def single_line_message(message):
	"""
	:type message: str | unicode
	:rtype: unicode
	"""
	message = message.strip()
	return u" ".join([line.strip() for line in message.split('\n')])


def multi_line_message(message):
	"""
	:type message: str | unicode
	:rtype: unicode
	"""
	lines = [line for line in message.split('\n')]
	empty_lines = 0
	for i, line in enumerate(lines):
		if line.strip() == '':
			empty_lines = i + 1
		else:
			break
	message = u"\n".join(lines[empty_lines:])
	return textwrap.dedent(message.rstrip())
