from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import DNSIssueType

MESSAGES = {}

MESSAGES[DNSIssueType.DIFFERENT_RECORDS] = format_message("""
The DNS server at {server_ip} returned incorrect DNS records. {difference}
""")

MESSAGES[DNSIssueType.DNS_SERVER_TIMEOUT] = format_message("""
The DNS query to the {server_name} at {server_ip} was timed out.
""")

MESSAGES[DNSIssueType.INTERNAL_ERROR] = format_message("""
An internal error occurred: {reason}
Unable to check whether the DNS zone is resolved by the {server_name} at {server_ip}.
""")

MESSAGES['dns_difference_example'] = format_message("""
Here is an example of differing records:
{example_difference}
All information about the differences is saved to the file {filename}
""")

MESSAGES['dns_difference_full'] = format_message("""
Here is the difference:
{difference}
""")

MESSAGES['dns_file_difference'] = format_message("""
The DNS server at {server_ip} returned incorrect DNS records:
{difference}
""")
