from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import MailAuthIssueType

MESSAGES = {}

MESSAGES[MailAuthIssueType.MAIL_IP_NOT_DEFINED] = format_message("""
Make sure that:
1. The subscription is present in the target Plesk.
2. The mail service is enabled for the subscription in the target Plesk.
""")

MESSAGES[MailAuthIssueType.MAILUSER_NOT_EXIST] = format_message("")

MESSAGES[MailAuthIssueType.CHECK_FAILED_IMAP] = format_message("""
Make sure that:
1. Mailboxes are present in the target Plesk.
2. The mail service is enabled for the subscription in the target Plesk.
3. The subscription in the target Plesk is not suspended.
4. The target Plesk mail server is working and it accepts connections by IMAP.

Ignore this warning if you have changed the password for the mailbox(es) or deleted the mailbox after transfer.
""")

MESSAGES[MailAuthIssueType.INTERNAL_ERROR_IMAP] = format_message("""
Check whether it is possible to log in to the mailbox over IMAP
""")

MESSAGES[MailAuthIssueType.CHECK_FAILED_SMTP] = format_message("""
Make sure that:
1. The mailboxes are present in the target Plesk.
2. The mail service is enabled for the subscriptions in the target Plesk.
3. The subscription in the target Plesk is not suspended.
4. The target Plesk mail server is working and it accepts connections by SMTP.

Ignore this warning if you have changed the password for the mailbox(es) or deleted the mailbox after transfer.
""")

MESSAGES[MailAuthIssueType.INTERNAL_ERROR_SMTP] = format_message("""
Check whether it is possible to authenticate as the mail user over SMTP.
""")

MESSAGES[MailAuthIssueType.CHECK_FAILED_POP3] = format_message("""
Make sure that:
1. The mailboxes are present in the target Plesk.
2. The mail service is enabled for the subscriptions in the target Plesk.
3. The subscription in the target Plesk is not suspended.
4. The target Plesk mail server is working and it accepts connections by POP3.

Ignore this warning if you have changed the password for the mailbox(es) or deleted the mailbox after transfer.
""")

MESSAGES[MailAuthIssueType.INTERNAL_ERROR_POP3] = format_message("""
Check whether it is possible to authenticate as the mail user over POP3.
""")

MESSAGES[MailAuthIssueType.MESSAGES_COUNT_INTERNAL_ERROR] = format_message("""
Make sure that:
1. The mailboxes are present in the target Plesk.
2. The mail service is enabled for the subscriptions in the target Plesk.
3. The subscription in the target Plesk is not suspended.
4. The target Plesk mail server is working and it accepts connections by POP3 or IMAP.

Ignore this warning if you have changed the password for the mailbox(es) or deleted the mailbox after transfer.
""")

MESSAGES[MailAuthIssueType.MESSAGES_COUNT_INTERNAL_ERROR] = format_message("""
Check whether it is possible to count messages the mail user on source and target server.
""")

MESSAGES[MailAuthIssueType.MESSAGES_COUNT_SIGNIFICANT_DIFFERENCE] = format_message("""
Please try to migrate mail content once more.
""")

MESSAGES[MailAuthIssueType.MESSAGES_COUNT_INSIGNIFICANT_DIFFERENCE] = format_message("""
Please try to migrate mail content once more.
""")
