from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import MSSQLDatabaseIssueType

MESSAGES = {}

MESSAGES[MSSQLDatabaseIssueType.DIFFERENT_TABLES_SET] = format_message("""
Make sure that the database content was migrated successfully.
If it was not, run the "{util_name} copy-db-content" command
to retry migrating the database content, or copy the database content manually.
""")

MESSAGES[MSSQLDatabaseIssueType.DATABASE_DOES_NOT_EXIST_IN_PANEL] = format_message("""
To transfer the database from the source server, you need to either restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command, 
or create the database manually from the hosting panel and then run the '{util_name} copy-db-content' command.
""")

MESSAGES[MSSQLDatabaseIssueType.DATABASE_USER_DOES_NOT_EXIST_IN_PANEL] = format_message("""
Most likely some web application, which uses the database, does not work after migration.
To transfer the database user from the source server, you need to try to restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command. 
Another way is to recreate the user manually.
""")

MESSAGES[MSSQLDatabaseIssueType.FAILED_TO_LOGIN_TO_TARGET_SERVER_AS_ADMIN] = format_message("""
Please make sure that:
1) The target Microsoft SQL Server is started and running.
2) There are no firewall rules that may block connection to the server.
""")

MESSAGES[MSSQLDatabaseIssueType.FAILED_TO_LOGIN_TO_TARGET_DATABASE_AS_ADMIN] = format_message("""
Ensure that the database is present in the hosting panel and on the target database server.

To transfer database from the source server, you need to restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command, 
or create the database manually from the hosting paneland then run the '{util_name} copy-db-content' command.
""")

MESSAGES[MSSQLDatabaseIssueType.FAILED_TO_LOGIN_AS_USER] = format_message("""
Ensure that the database user is present in the hosting panel and on the target database server.
Another possible reason is that password was changed for that user on the target panel after migration.
""")

MESSAGES[MSSQLDatabaseIssueType.FAILED_TO_FETCH_TABLES_FROM_SOURCE] = format_message("""
Please make sure that:
1. The source Microsoft SQL Server is started and running.
2. There are no firewall rules that may block connection to the server.
If that does not help, check manually that database tables were copied correctly.
""")

MESSAGES[MSSQLDatabaseIssueType.INTERNAL_ERROR] = format_message("""
Check manually whether this database and database users were migrated properly.
""")
