from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import DNSIssueType

MESSAGES = {}

MESSAGES[DNSIssueType.DIFFERENT_RECORDS] = format_message("""
Make sure that:
1. There are no pending or failed tasks related to DNS in PPA task manager.
2. The DNS zone of this domain exists in PPA and is enabled.
3. All desired DNS records exist in PPA and are active.

Ignore this warning if you have changed DNS zone after migration and the resolved records look fine.
""")

MESSAGES[DNSIssueType.DNS_SERVER_TIMEOUT] = format_message("""
Make sure that:
1. The DNS server is up.
2. BIND is started on the server.
3. There are no firewall rules blocking requests to the server.
""")

MESSAGES[DNSIssueType.INTERNAL_ERROR] = format_message("""
Manually check whether this zone is resolved properly by PPA DNS server.
""")
