param(
	[string]$hostname,
	[string]$database,
	[string]$login,
	[string]$password
)

try {
	$connectionStringBuilder = New-Object -TypeName System.Data.SqlClient.SqlConnectionStringBuilder
	$connectionStringBuilder.Add('Server', $hostname)
	$connectionStringBuilder.Add('Database', $database)
	$connectionStringBuilder.Add('UID', $login)
	$connectionStringBuilder.Add('PWD', $password)
	$connectionStringBuilder.Add('Connection Timeout','30')

	$connection = New-Object -TypeName System.Data.SqlClient.SqlConnection
	$connection.ConnectionString = $connectionStringBuilder.ToString()

	$command = $connection.CreateCommand()
	$command.CommandText = "EXEC sp_databases" # Just a test command to execute over connection, we do not check any results
	$adapter = New-Object -TypeName System.Data.SqlClient.SqlDataAdapter $command
	$dataset = New-Object -TypeName System.Data.DataSet
	$adapter.Fill($dataset) > $null
	Write-Host "OK"
} catch [Exception] {
	Write-Host $_.Exception.Message
	exit 1
}

