import re

class HtmlParser(object):
	"""Retrieve parts of HTML document."""
	@staticmethod
	def get_tag_content(tag, html):
		"""Get contents of the tag.
		
		Args:
			tag: tag name
			html: HTML document to be searched for the tag
		Returns:
			list with tag contents, one element per tag occurence.
		"""
		return re.findall('<%s[^>]*>([^<]*)</' % (tag,), html, re.IGNORECASE) 

	@staticmethod
	def get_tag_attributes(tag, attributes, html):
		"""For each found tag, return list of attributes with their content."""
		found_attributes = []
		rx = '<%s[^>]*[\s]+%s[\s]*=[\s]*[\'"]([^\s"\'>]+)[\'"]'
		for attr in attributes:
			attr_list = re.findall(rx % (tag, attr), html, re.IGNORECASE)
			if attr_list:
				found_attributes.extend(attr_list)
		return found_attributes
		

