from parallels.plesk import messages
from contextlib import contextmanager

from parallels.core.connections.target_servers import TargetServer
from parallels.core.connections.plesk_server import PleskServer
from parallels.core.panel.server.plesk_family import HostingServer
from parallels.core.utils import plesk_api_utils
from parallels.core.utils.common import cached


class PleskTargetServer(TargetServer, PleskServer):
	def __init__(self, conn):
		self.conn = conn

	@contextmanager
	def runner(self):
		with self.conn.main_node_runner() as runner:
			yield runner

	@cached
	def plesk_api(self):
		return self.conn.plesk_api()

	def get_hosting_server(self):
		return HostingServer(self)

	def get_session_file_path(self, filename):
		return self.conn.session_dir_obj.get_file_path(filename)

	def session_dir(self):
		return self.conn.session_dir_obj.get_session_dir_path()

	def is_windows(self):
		return self.conn.is_windows

	def description(self):
		return messages.TARGET_PLESK_SERVER_TITLE

	def ip(self):
		return self.conn.main_node_ip

	def ips(self):
		return {self.ip()}

	def __hash__(self):
		return hash('1')

	def __eq__(self, another): 
		return isinstance(another, PleskTargetServer)

	@property
	@cached
	def plesk_version(self):
		"""Return a tuple with Plesk server version."""
		version = plesk_api_utils.get_plesk_version(
			self.conn.plesk_api()
		)
		return tuple(map(int, (version.split("."))))
