# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
use strict;
use warnings;

package Preferences;

# HTTPD special options are migrated to vhost.conf. However in most cases they cannot be migrated 
# completely automatically, so you have to edit vhost.conf files manually. So there are 2 choices:
# 
# 1. (default) Valid Apache configuration, all options commented.
# You can uncomment these options after migration manually, in each vhost.conf.
# Set the following option to 1 to get this behavior.
# 
# 2. (not recommended) Potentially invalid Apache configuration, all options are not commented. 
# Most probably you will have to urgently fix each vhost.conf file to get web service working.
# IMPORTANT: Apache may not start with invalid configuration, which implies that WEB SERVICE FOR ALL USERS will be BROKEN. 
# Set the following option to 0 to get this behavior.
#
# In any case after migration you should go to HTTPD_VHOSTS_D (you could take this path from /etc/psa/psa.conf), find
# all vhost.conf files and correct settings. Variables like ##user##, ##kunde##, ##user_home##, ##domain## are not
# substituted automatically, at least because combinations of them could have a special meaning. For example,
# ##user_home##/##user## most probably should be replaced with domain home directory.
our $commentHttpdSpecials = 1;

1;
