import logging

from parallels.plesk.source.custom.web_files import CustomPanelWebFiles
from parallels.plesk.source.plesk.actions.content.web.copy_unix_content import CopyUnixWebContentBase


logger = logging.getLogger(__name__)


class CustomPanelCopyUnixWebContent(CopyUnixWebContentBase):
	"""Copy web content from custom panel's Unix server (access to the server was provided in configuration file)"""

	def filter_subscription(self, global_context, subscription):
		"""Check if we should run this action on given subscription or not

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.plesk.source.custom.migrated_subscription.CustomPanelMigratedSubscription
		"""
		return (
			super(CustomPanelCopyUnixWebContent, self).filter_subscription(global_context, subscription)
			and
			global_context.conn.has_hosting_description_config(subscription.model.source)
		)

	def _list_files_to_copy(self, global_context, subscription):
		"""Make a list of source server directories and files to be transferred.

		Return:
			A list of (source directory -> destination directory) mappings

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.plesk.source.custom.migrated_subscription.CustomPanelMigratedSubscription
		:rtype: list[parallels.core.utils.paths.copy_web_content.CopyWebContentItem]
		"""
		return CustomPanelWebFiles().list_files_to_copy(global_context, subscription)