import argparse
from parallels.core.cli.common_cli import Command, CommandTypes
from parallels.core.cli.extension import CLIExtensionBase
from parallels.plesk.source.custom import messages


class CLIExtension(CLIExtensionBase):
	"""Command line migrator interface extension for source custom panel"""

	def get_additional_commands(self, common_options):
		"""
		:type common_options: parallels.core.cli.migration_cli.CommonMigrationOptions
		:rtype: list[parallels.core.cli.common_cli.Command]
		"""

		create_full_backup_opts = argparse.ArgumentParser(add_help=False)
		create_full_backup_opts.add_argument(
			'--source-file', action='store',
			help=messages.SOURCE_HOSTING_DESCRIPTION_FILE_OPTION
		)
		create_full_backup_opts.add_argument(
			'--source-format', action='store',
			help=messages.SOURCE_HOSTING_DESCRIPTION_FORMAT_OPTION,
			default='yaml'
		)
		create_full_backup_opts.add_argument(
			'--target-file', action='store',
			help=messages.TARGET_DUMP_FILE_OPTION
		)

		return [
			Command(
				'create-dump-from-hosting-description', CommandTypes.INTERNAL,
				messages.COMMAND_CREATE_DUMP_FROM_HOSTING_DESCRIPTION,
				lambda m, o: m.create_plesk_config_dump_from_hosting_description(),
				common_options.global_options_list + [create_full_backup_opts],
				is_legacy=True
			),
		]