from parallels.core.utils.message_utils import single_line_message
from parallels.core.utils.message_utils import multi_line_message

LOG_EXCEPTION = single_line_message("""
	Exception:
""")
UNDO_SUBDOMAIN_DNS_FORWARDING_FAILURE = single_line_message("""
	Could not undo the DNS forwarding for subdomain '%s', error occurred on Expand centralized DNS server: '%s'
""")
LOG_SYNC_ZONE_FROM_EXPAND_TO_CDNS = single_line_message("""
	Synchronize zone from Expand database to CDNS server
""")
SET_SUBDOMAIN_DNS_FORWARDING_FAILURE = single_line_message("""
	Could not set up the DNS forwarding for subdomain '%s', error occurred on Expand centralized DNS server: '%s'
""")
UNABLE_TO_PERFORM_DNS_FORWARDING_OPERATION_FOR_DOMAIN_CDNS_NOT_DESCRIBED = single_line_message("""
	Unable to %s for domain '%s', because Expand centralized DNS server serving it (IP: %s) is not described in
	migration tool's configuration file
""")
SET_ALL_SUBDOMAINS_DNS_FORWARDING_FAILURE = single_line_message("""
	Could not set up the DNS forwarding for all subdomains of Plesk '%s'. Error is: %s
""")
UNABLE_TO_PERFORM_DNS_FORWARDING_OPERATION_FOR_ALL_CDNS_NOT_DESCRIBED = single_line_message("""
	Failed to %s for all domains of Plesk '%s', because associated centralized DNS server (IP: %s) is not listed in
	migration tool's configuration file
""")
UNDO_DNS_FORWARDING_ALL_SUBDOMAINS_FAILURE = single_line_message("""
	Could not undo the DNS forwarding for all subdomains of Plesk '%s'. Error is: %s
""")
FAILED_TO_FIND_EXPAND_DOMAIN = single_line_message("""
	Failed to find Expand domain '%s'
""")
LOG_GET_CDNS_ZONE_INFO = single_line_message("""
	Get centralized DNS zone information for domain '%s'
""")
UNABLE_TO_PERFORM_DNS_FORWARDING_OPERATION_FOR_DOMAIN_CNDS_FAILURE = single_line_message("""
	Could not %s for domain '%s,'error occurred on Expand centralized DNS server: '%s'
""")
LOG_UPDATE_EACH_DNS_ZONE = single_line_message("""
	Update each DNS zone on a system
""")
UNABLED_TO_UNDO_DNS_FORWARDING_FOR_ALL_SUBDOMAINS_CDNS_NOT_DESCRIBED = single_line_message("""
	Unable to undo the DNS forwarding for all subdomains of Plesk '%s', because associated centralized DNS server (IP:
	%s) is not described in migration tool's configuration file
""")
LOG_REFRESH_EXPAND_ZONES_DATABASE = single_line_message("""
	Refresh Expand zones database from Plesk zones database
""")
FAILED_TO_FIND_EXPAND_SERVER = single_line_message("""
	Failed to find Expand server matching '%s' source ID
""")
FORCE_RETRANSFER_ZONE_DATA_FROM_TARGET = single_line_message("""
	Force retransfer zone data from target server DNS. Serial and TTLs are ignored, zone data is updated always.
""")
UNABLE_UNDO_DNS_FORWARDING_FOR_SUBDOMAIN_CDNS_NOT_DESCRIBED = single_line_message("""
	Unable to undo the DNS forwarding for subdomain '%s' because Expand centralized DNS server (IP: %s) serving its DNS
	zone is not described in migration tool's configuration file
""")
UNABLE_TO_SET_DNS_FORWARDING_FOR_SUBDOMAIN_CDNS_NOT_DESCRIBED = single_line_message("""
	Unable to set up the DNS forwarding for subdomain '%s' because Expand centralized DNS server (IP: %s) serving its
	DNS zone is not described in migration tool's configuration file
""")
UNABLE_TO_SET_DNS_FORWARDING_FOR_ALL_SUBDOMAINS_CDNS_NOT_DESCRIBED = single_line_message("""
	Unable to set up the DNS forwarding for all subdomains of Plesk '%s', because associated centralized DNS server (IP:
	%s) is not described in migration tool's configuration file
""")
LOG_FORCE_RETRANSFER_ZONE_DATA_FROM_TARGET = single_line_message("""
	Force retransfer zone data from target server DNS. Serial and TTLs are ignored, zone data is updated always.
""")
FAILED_TO_LOGIN_TO_EXPAND_BY_SSH = multi_line_message("""
	Unable to login to Expand SSH service due to incorrect login/password specified in config file.
	Set valid credentials in 'ssh-username' and 'ssh-password' options in [expand] section
	in config file and re-run migration tool.
""")
CMAIL_MIGRATION_FROM_UNIX_TO_WINDOWS_NOT_SUPPORTED = single_line_message("""
	Migration from Unix centralized mail server '%s' to Plesk for Windows is not supported.
	If you want to proceed migration to Plesk you should remove that
	centralized mail server from configuration file and then migrate it manually.
""")
FAILED_TO_LOGIN_TO_EXPAND_BY_EXPAND_API = multi_line_message("""
	Unable to login to Expand API service due to incorrect login/password specified in config file.
	Set valid credentials in 'panel-username' and 'panel-password' options in [expand] section in config file
	and re-run migration tool.
""")
EXTRACT_AUX_USERS = single_line_message("""
	Extract auxiliary users for client '%s'
""")
PANEL_ACCESS_WILL_NOT_BE_TRANSFERRED = single_line_message("""
	Panel access for the mail user '%s' will not be transferred to target panel.
	You can create corresponding additional user in target hosting panel after transfer.
""")
CLIENT_EXISTS_ON_ANOTHER_PLESK = single_line_message("""
	A client with the same username already exists on another Plesk server but is associated with another Expand client
""")
SOLUTION_CHANGE_USERNAME_OF_CLIENT_OR_REASSIGN = single_line_message("""
	Either change username of this client or associate both Plesk clients with the same Expand client.
""")
DOMAIN_ADMIN_WILL_NOT_BE_TRANSFERRED = single_line_message("""
	Domain administrator '%s' will not be transferred to target panel.
	You can create corresponding additional user in target hosting panel after transfer.
""")
DOMAIN_UNABLE_TO_FILE_PLESK_SERVER_FOR_CMAIL_SERVER = single_line_message("""
	Domain '%s' belongs to client '%s' in centralized mail server '%s', but no such client found in Plesk servers
""")
MAIL_USER_UNABLE_TO_FILE_PLESK_SERVER_FOR_CMAIL_SERVER = single_line_message("""
	Mail user '%s' belongs to client '%s' in centralized mail server '%s', but no such client found in Plesk servers
""")
EXTRACT_AUX_USERS_FROM_CENTRALIZED_MAIL = single_line_message("""
	Extract auxiliary users from centralized mail '%s'
""")
PLESK_CLIENT_ON_SOURCE_PLESK_SERVER = single_line_message("""
	Plesk client on source Plesk server '%s'
""")
SOLUTION_REMOVE_DIFFERENCE_BETWEEN_CLIENTS = single_line_message("""
	Either remove the difference (if both accounts belong to the same client) or change the client's username (if these
	are the different clients).
""")
EXPAND_CLIENT_ON_SOURCE_EXPAND_SERVER = single_line_message("""
	Expand client on source Expand server
""")
CLIENT_DOES_NOT_EXIST = single_line_message("""
	Client '{login}' is presented in migration list, but is presented neither on source Expand nor on target Plesk.
""")
LOG_CONVERT_CLIENTS_FROM_TARGET_PANEL = single_line_message("""
	Convert clients from target panel
""")
CUSTOMER_OR_RESELLER_DOES_NOT_EXIST = single_line_message("""
	Customer or reseller '%s' does not exist in source or in destination panel, subscription will not be transferred.
""")
SOLUTION_SPECIFY_THE_ONLY_SERVER_TO_MIGRATE_SUBSCRIPTION = single_line_message("""
	Specify the only server of these source servers in config.ini to migrate that subscription.
""")
CREATE_CUSTOMER_OR_RESELLER_MANUALLY = single_line_message("""
	Create the customer or reseller with such login manually, or map subscription to any other existing customer or
	reseller.
""")
SUBSCRIPTION_EXISTS_ON_MULTIPLE_SOURCE_PANELS = single_line_message("""
	Subscription '%s' exists on multiple source panels: %s. Subscription will not be transferred as we don't know from
	which source server to take it.
""")
SUBSCRIPTION_DOES_NOT_EXIST_ON_SOURCE = single_line_message("""
	Subscription '%s' does not exist on source panel, subscription will not be transferred.
""")
SOLUTION_CORRECT_SUBSCRIPTION_NAME = single_line_message("""
	Fix the migration list: correct subscription's name or exclude subscription from the list
""")
FAILED_TO_FETCH_DATA_FROM_EXPAND = single_line_message("""
	Failed to fetch data from Expand main server
""")
IP_ADDRESSES_DO_NOT_MATCH = single_line_message("""
	Please fix migrator configuration (selected source Plesks, IP addresses in their sections should match IP addresses
	of the same Plesk servers in Expand)
""")
IP_ADDRESSES_CMAIL_DO_NOT_MATCH = single_line_message("""
	Please fix migrator configuration (selected centralized mail servers, IP addresses in their sections should match IP
	addresses of the same centralized mail servers in Expand)
""")
SKIP_LOADING_EXPAND_DATA_FILE = single_line_message("""
	Expand data file already exists, skip loading
""")
NO_EXPAND_PLESK_SERVERS_FOR_SOURCE_PLESK_SERVER = single_line_message("""
	No Expand Plesk servers are found for source Plesk server(s) %s.
""")
ACTION_FETCH_DATA_FROM_EXPAND_MAIN_SERVER_DESCRIPTION = single_line_message("""
	Fetch data from Expand main server
""")
NO_EXPAND_CMAIL_SERVERS_FOR_SERVER_DESCRIBED_IN_CONFIG = single_line_message("""
	No Expand centralized mail servers are found for configuration section(s) %s.
""")
FETCH_PLESK_SERVERS_INFORMATION_FROM_EXPAND = single_line_message("""
	Fetch Plesk servers information from Expand database.
""")
ACTION_FETCH_DATA_FROM_CMAIL_FAILURE = single_line_message("""
	Failed fetch configuration data from centralized mail servers
""")
ACTION_FETCH_DATA_FROM_CMAIL_DESCRIPTION = single_line_message("""
	Fetch configuration data from centralized mail servers
""")
RESTORE_CMAIL_SETTINGS = single_line_message("""
	Restore centralized mail hosting settings of subscription
""")
FAILED_TO_RESTORE_CMAIL_SETTINGS = single_line_message("""
	Failed to restore centralized mail hosting settings of subscription '%s'
""")
GET_IP_ADDRESSES_OF_CENTRALIZED_DNS_SERVERS = single_line_message("""
	Get IP addresses of centralized DNS servers
""")
FETCH_INFORMATION_ABOUT_EXPAND_RESELLERS = single_line_message("""
	Fetch information about Expand resellers from Expand database.
""")
FETCH_DATA_FROM_EXPAND_DATABASE_BY_SQL_QUERY = single_line_message("""
	Fetch data from Expand database, query: %s
""")
EXPAND_SERVER_IS_SKIPPED_BECAUSE_NOT_IN_CONFIG = single_line_message("""
	Expand server #%s is skipped as its IP address '%s' is not among selected source Plesks IP addresses
""")
UNABLE_TO_RESOLVE_DATABASE_SERVER_HOSTNAME = single_line_message("""
	Unable to resolve database server hostname '%s'. It will be silently skipped.
""")
EXPAND_CMAIL_SERVER_SKIPPED_BECAUSE_NOT_IN_CONFIG = single_line_message("""
	Expand centralized mail server #%s is skipped as its IP '%s' is not among selected centralized mail servers IP
	addresses
""")
GET_IP_ADDRESSES_OF_CDB_SERVERS = single_line_message("""
	Get IP addresses of centralized database servers
""")
GET_IP_ADDRESSES_OF_PLESK_SERVERS = single_line_message("""
	Get IP addresses of Plesk servers
""")
GET_IP_ADDRESSES_OF_CMAIL_SERVERS = single_line_message("""
	Get IP addresses of centralized mail servers
""")
HOSTING_SETTINGS_DESCRIPTION = single_line_message("""
	hosting settings
""")
DEBUG_CONVERT_EXPAND_CLIENTS = single_line_message("""
	Convert source Expand clients
""")
DEBUG_CONVERT_PLESK_CLIENTS = single_line_message("""
	Convert source Plesk clients
""")
DEBUG_MERGE_CLIENTS = single_line_message("""
	Merge clients
""")
CLIENT_WITH_SAME_USERNAME_EXISTS = multi_line_message("""
	Client with the same username '{login}' but different {difference} exists on a number of servers:
	{info_list}
""")
SOLUTION_FIX_MIGRATION_LIST = single_line_message("""
	Fix migration list
""")
CLIENT_ON_TARGET_SERVER = single_line_message("""
	Client on target server
""")
CLIENT_FORMAT = single_line_message("""
	%s: username '%s', contact (first and last names) '%s', e-mail '%s'
""")
CLIENT_DIFFERENCE_EMAIL = single_line_message("""
	e-mail
""")
CLIENT_DIFFERENCE_CONTACT = single_line_message("""
	contact (first and last names)
""")
DEBUG_CONVERT_CLIENTS = single_line_message("""
	Convert clients
""")
DEBUG_CONVERT_EXPAND_RESELLERS = single_line_message("""
	Convert Expand resellers
""")
LOG_GET_EXPAND_CLIENTS = single_line_message("""
	Get Expand clients
""")
LOG_GET_PLESK_CLIENTS = single_line_message("""
	Get Plesk clients
""")
LOG_GET_PLESK_DOMAINS = single_line_message("""
	Get Plesk domains
""")
LOG_GET_PLESK_ALIASES = single_line_message("""
	Get Plesk aliases
""")
LOG_GET_SERVERS = single_line_message("""
	Get servers
""")
LOG_GET_EXPAND_RESELLERS = single_line_message("""
	Get Expand resellers
""")
LOG_GET_EXPAND_DATA_MODEL = single_line_message("""
	Get Expand data model
""")
LOG_EXPAND_HOST = single_line_message("""
	Expand host: %s
""")
EXPAND_MAIN_NODE_DESCRIPTION = single_line_message("""
	Expand main node ('%s')
""")
LOG_CDNS_HOST = single_line_message("""
	Centralized DNS '%s' host: %s
""")
DEBUG_CHECK_EXPAND_API_CONNECTION = single_line_message("""
	Check Expand API connection
""")
FAILED_TO_CONNECT_TO_EXPAND = single_line_message("""
	Failed to connect to Expand to '%s': %s
""")
DEBUG_CHECK_EXPAND_SSH = single_line_message("""
	Check Expand SSH connection
""")
FAILED_TO_CONNECT_TO_EXPAND_SSH = single_line_message("""
	Failed to connect to Expand SSH : %s
""")
EXPAND_MAIN_SERVER_DESCRIPTION = single_line_message("""
	Expand main server
""")
CDNS_SERVER_DESCRIPTION = single_line_message("""
	source centralized DNS server '%s' ('%s')
""")
FAILED_TO_PERFORM_OPERATION_FOR_DOMAIN = single_line_message("""
	Failed to %s for domain '%s'. Error is: %s
""")
FAILED_TO_PERFORM_OPERATION_FOR_ALL_DOMAINS = single_line_message("""
	Failed to %s for all domains of Plesk '%s'. Error is: %s
""")
UNDO_DNS_FORWARDING = single_line_message("""
	undo the DNS forwarding
""")
TITLE_SOURCE_TARGET = single_line_message("""
	Target panel
""")
TITLE_EXPAND = single_line_message("""
	Expand
""")
TITLE_PLESK = single_line_message("""
	Plesk '%s'
""")