# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
package PreMigrationMessages;

use strict;
use warnings;

use PreMigration;

# Context variables common to all messages
our %COMMON_CONTEXT = (
    'panelName' => 'PPCPL',
  );

our %MESSAGES = (
  'DUPLICATED_SITE_LOGIN_NAMES' => {
    'severity' => PreMigration::WARNING,
    'briefMessage' => "Duplicate site administrator usernames were found on the {panelName} installation.",
    'detailedMessage' => "Parallels Plesk Panel does not allow duplicate usernames. Duplicates will be automatically renamed during migration. The affected usernames are {duplicateList}."
  },
  'POWER_TOOLS_AVAILABLE' => {
    'severity' => PreMigration::WARNING,
    # TODO it may also be useful to find actual usage of power tools 
    # (complicated because there is a separate database table per application, i.e a table named 'xoops-2.0.16-1.0')
    'briefMessage' => "There are power tools available to the administrator of the site {domain}. The control panel settings of installed power tools will not be migrated.",
    'detailedMessage' => "The installed power tools can only be migrated as files. Application files and databases will be migrated, but the settings in control panel will not. The application settings and functionality should be verified after migration."
  },
  'MAILING_LISTS' => {
    'severity' => PreMigration::WARNING,
    'briefMessage' => "There are mailing lists used by the administrator of the site {domain}. Message archives will not be migrated.",
    'detailedMessage' => "Only administrator's e-mail, password, and subscribers' e-mail addresses are migrated."
  },
  'CRON_JOBS' => {
    'severity' => PreMigration::WARNING,
    'briefMessage' => "Site '{domain}' has crontab entries. Cron jobs cannot be migrated.",
    'detailedMessage' => 'Migration of crontab entries is not supported by the current version of migration agent. You should move all crontab entries to Parallels Plesk Panel server manually.'
  },
  'NAMED_NOT_RUNNING' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "DNS zones migration is not possible: 'named' service is stopped",
    'detailedMessage' => "Migration of DNS zones is not possible while 'named' service is stopped. Please start the service if DNS zones migration is desired."
  },
  'DB_USER_ADMIN' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "DB user 'admin' in site '{domain}' will be renamed upon migration.",
    'detailedMessage' => "DB user name 'admin' is prohibited in Plesk. You may rename it manually or it will be renamed automatically during migration.",
  },

);
