from xml.etree import ElementTree


def get_installed_components(plesk_server):
	"""Get list of components installation status in simple format

	For now only Perl and Python are supported. Extend if necessary.
	Example result: {'perl': True, 'python': False}

	:rtype: dict[str, bool]
	"""
	components = {}

	with plesk_server.runner() as runner:
		packages_xml_str = runner.sh(ur'%s\admin\bin\defpackagemng --get' % plesk_server.plesk_dir)
		packages_xml = ElementTree.fromstring(packages_xml_str)
		for elem in packages_xml.findall('type'):
			if elem.attrib.get('name') == 'script.python':
				name = 'python'
			elif elem.attrib.get('name') == 'script.perl':
				name = 'perl'
			else:
				name = None

			if name is not None:
				installed = False
				package_node = elem.find('package')
				if package_node is not None:
					installed = package_node.attrib.get('state') != 'not_installed'

				components[name] = installed

	return components