from parallels.core.utils.message_utils import single_line_message
from parallels.core.utils.message_utils import multi_line_message

DNS_SERVER_IS_NOT_REGISTERED_IN_PPA = single_line_message("""
	DNS server %s is not registered in PPA, consider it as external DNS server
""")
MIGRATION_TO_PPA_OF_THIS_VERSION_IS_NOT_SUPPORTED = single_line_message("""
	Migration to PPA %s is not supported. We strongly recommend that you install the latest version of PPA for
	migration. If you still want to migrate to PPA 11.1.x, please use the previous version of migration tools:
	http://autoinstall.plesk.com/PPA_11.1.0/migration-tools/ (not recommended).
""")
CLIENT_WAS_NOT_ADDED_INTO_SPECIAL_PPA_ACCOUNT = single_line_message("""
	Client '%s' should have been added into special_ppa_clients, but it is not so
""")
MAILBOX_QUOTA_SOLUTION = single_line_message("""
	Increase service template limit on the destination panel, or decrease mailbox quota on the source server and run
	migration tool with --reload-source-data option.
""")
SERVICE_TEMPLATE_HAS_NOT_ENOUGH_RESOURCES = single_line_message("""
	The service template #%s (named '%s', owned by account #%s) does not have enough resources to add the webspace '%s'
	into a new subscription based on that service template.
""")
CLIENT_MAPPED_TO_UNEXISTING_RESELLER = single_line_message("""
	Client is mapped to an unexisting reseller '%s'
""")
NEW_PASSWORD_FOR_AUX_USER = single_line_message("""
	A new password was generated for the auxiliary user '%s': '%s'. You can change the password for the corresponding
	auxiliary user in the destination panel once the data transfer is finished.
""")
DNS_ZONE_MANAGED_BY_EXT_DNS = single_line_message("""
	The DNS zone '%s' of this subscription is managed by an external server.
""")
SUBSCRIPTION_HAS_NO_PLAN_ID_AND_PLAN_NAME = single_line_message("""
	somehow, subscription '%s' has neither plan_id nor plan_name defined
""")
PPA_HAS_SPECIAL_CUSTOMER_ACCOUNT = single_line_message("""
	PPA has the special '{login}' customer account reserved for subscriptions owned by {owner}. As '{login}' already
	exists in PPA, all such subscriptions from this server will be transferred under this account.
""")
ROLE_WILL_NOT_BE_TRANSFERRED = single_line_message("""
	This role will not be transferred. The users with this role will be reassigned to the existing role. If you want to
	transfer the role, change its name.
""")
ASSIGN_SUBSCRIPTION_TO_SERVICE_TEMPLATE = single_line_message("""
	Assign the subscription to a service template using the migration list file.
""")
SUBSCRIPTION_ASSIGNED_TO_SERVICE_TEMPLATE_WITH_NO_FEATURE = single_line_message("""
	Subscription is assigned to a service template '%s' that has no '%s'
""")
DNS_SERVER_IN_SLAVE_MODE = single_line_message("""
	The DNS server in Plesk Panel works in the slave mode for the subscription's DNS zone '%s'.
""")
ROLE_FOR_AUX_USERS_EXISTS_ON_OTHER_SERVER = single_line_message("""
	A role '%s' for auxiliary users exists on the other server and has the different set of permissions
""")
UNABLE_TO_GET_AUXILIARY_USER_PASSWORD = single_line_message("""
	Unable to retrieve the auxiliary user's password as it is stored in the encrypted form
""")
SERVICE_TEMPLATE_MAY_HAVE_NOT_ENOUGH_RESOURCES = single_line_message("""
	The service template #%s (named '%s', owned by account #%s) may not have enough resources to add the webspace '%s'.
	For your convenience, the migration tool will allocate resources to a webspace even if they are not required by the
	subscription being transferred. However, because the order of creating webspaces is not defined, resources may be
	exhausted before creating a webspace for the subscription that requires them.
""")
ADJUST_LIMITS_OR_TRANSFER_IN_SINGLE_MODE_SOLUTION = single_line_message("""
	You can either adjust the subscription's limits on the hosting types: ({hostings_lacking}) and re-transfer this
	subscription, or transfer this subscription in the single-webspace mode.
""")
USER_WILL_NOT_BE_TRANSFERRED = single_line_message("""
	The user will not be transferred. If you want this user to be transferred, change its username.
""")
AUXILIARY_USER_ALREADY_EXISTS = single_line_message("""
	An auxiliary user with the username '%s' already exists in the destination panel
""")
CREATE_SERVICE_TEMPLATE_WITH_NAME = single_line_message("""
	Create a service template with this name, or assign subscription to other service template
""")
CUSTOMER_WITH_SPECIAL_USERNAME_ALREADY_EXISTS = single_line_message("""
	A customer with the special username '%s' already exists in PPA
""")
SUBSCRIPTION_IS_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
	Subscription '%s' is not listed in migration list, not including it into target model
""")
SUBSCRIPTION_IS_ASSIGNED_TO_SERVICE_TEMPLATE_WITH_BAD_MAIL_QUOTA = single_line_message("""
	Subscription is assigned to a service template '%s' that has mailbox quota limit (%s) less than mailbox quota of
	mailbox '%s' (%s). Mailbox can not be transferred.
""")
ONE_AUXILIARY_USER_WILL_BE_TRANSFERRED = single_line_message("""
	Only one auxiliary user will be transferred. The priority will be given to the user from the other server. If you
	want to transfer both users, rename one of them.
""")
ADD_MISSING_HOSTINGS_INTO_WEBSPACE = single_line_message("""
	Add missing hostings into that webspace manually and then re-transfer this subscription
""")
NO_SERVICE_TEMPLATE_WITH_SUCH_NAME = single_line_message("""
	%s does not have a service template named '%s', unable to make a subscription on it. Subscription will not be
	transferred.
""")
CONVERT_AUXILIARY_USER_ROLE = single_line_message("""
	Convert auxiliary user role '%s'
""")
ASSIGN_SUBSCRIPTION_TO_SERVICE_TEMPLATE_WITH_FEATURE = single_line_message("""
	Assign this subscription to a service template which offers %s.
""")
CLIENT_IS_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
	Client '%s' is not listed in migration list, not including it into target model
""")
CHECK_DNS_ZONES_OF_SUBSCRIPTION = single_line_message("""
	Check DNS zones of subscription '%s'
""")
SUBSCRIPTION_MAY_NOT_HAVE_ENOUGH_RESOURCES = single_line_message("""
	The subscription #%s may not have enough resources to add the webspace '%s'. For your convenience, the migration
	tool will allocate resources to a webspace even if they are not required by the subscription being transferred.
	However, because the order of creating webspaces is not defined, resources may be exhausted before creating a
	webspace for the subscription that requires them.
""")
ONE_ROLE_WILL_BE_TRANSFERRED = single_line_message("""
	Only one role will be transferred. The priority will be given to the role from the other server. If you want to
	transfer both roles separately, rename one of them.
""")
AUXILIARY_USER_WITH_DIFFERENT_CONTACT_INFO = single_line_message("""
	An auxiliary user with the username '%s' but different contact information exists on the other server
""")
IDN_DOMAIN_ADMIN_WILL_NOT_BE_TRANSFERRED = single_line_message("""
	Domain administrator of domain '%s' will not be migrated: migration of domain administrators for IDN domains is not
	supported.
""")
SUBSCRIPTION_DOES_NOT_HAVE_ENOUGH_RESOURCES = single_line_message("""
	The subscription #%s does not have enough resources to add the webspace '%s'
""")
SPECIAL_CLIENT_HAS_NO_SUBSCRIPTIONS_ASSIGNED = single_line_message("""
	Special client '%s' has no subscriptions assigned to it, not including it into target model
""")
WEBSPACE_ALREADY_EXISTS_BUT_DOES_NOT_INCLUDE_HOSTINGS = single_line_message("""
	The webspace '%s' already exists, but does not include the following hostings: %s
""")
TRANSFER_OF_INSTANT_MESSENGER_FIELD_NOT_SUPPORTED = single_line_message("""
	The transfer of the instant messenger field in the contact information is not supported
""")
CUSTOMER_DOES_NOT_EXIST = single_line_message("""
	Customer '%s' does not exist in source or in destination panel, subscription will not be transferred.
""")
SKIP_CHECKING_DNS_ZONE_OF_DOMAIN = single_line_message("""
	Skip checking DNS zone of domain '%s': it has no DNS zone
""")
CHANGE_DNS_RECORDS_MANUALLY_ON_EXT_DNS = single_line_message("""
	Once the transfer is finished, manually change DNS records on the external DNS server(s) (including MX records) and
""")
MIGRATE_ADDITIONAL_CONTACT_INFO_FIELD_MANUALLY = single_line_message("""
	Migrate additional contact information field manually
""")
RUN_TOOL_WITH_COPY_MAIL_CONTENT_COMMAND = single_line_message("""
	run the tool with the 'copy-mail-content' command to complete mail content sync.
""")
ROLE_FOR_AUXILIARY_USERS_ALREADY_EXISTS_WITH_DIFFERENT_PERMISSIONS = single_line_message("""
	A role '%s' for auxiliary users already exists in the destination panel and has the different set of permissions
""")
SUBSCRIPTION_NOT_ASSIGNED_TO_SERVICE_TEMPLATE = single_line_message("""
	This subscription is not assigned to any service template. Migration of such subscriptions is not supported
""")
FORM_UP_TARGET_MODEL = single_line_message("""
	Form up target model objects based on source backups
""")
ADJUST_SERVICE_TEMPLATES_LIMITS = single_line_message("""
	You can adjust this service template's limits on the hosting types: ({hostings_lacking}) and re-transfer this
	subscription; or you can transfer this subscription in the single-webspace mode.
""")
SOLUTION_CREATE_RESELLER_IN_DESTINATION_PANEL = single_line_message("""
	Create this reseller in destination panel, or map client to some existing reseller
""")
SOLUTION_CREATE_CUSTOMER_WITH_SUCH_LOGIN_MANUALLY = single_line_message("""
	Create the customer with such login manually, or map subscription to any other existing customer.
""")
TRANSFER_OF_ADDITIONAL_CONTACT_INFO_FIELD_NO_SUPPORTED = single_line_message("""
	The transfer of the additional contact information field is not supported
""")
CLIENT_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
	Client '%s' is not listed in migration list, not including its aux users into target model
""")
CHANGE_DNS_RECORDS_ON_EXT_DNS = single_line_message("""
	Once the transfer is finished, manually change DNS records on the external DNS server(s).
""")
MIGRATOR_INTERNAL_ERROR_ACCOUNT_OF_UNSUPPORTED_TYPE = single_line_message("""
	Migrator internal error: trying to get PPA accounts with unsupported type '%s'
""")
MIGRATOR_HAS_NO_INFO_ABOUT_WEBSPACE_PROVISIONING = single_line_message("""
	Migrator has no information about this webspace provisioning, as if it was created manually.
""")
SUBSCRIPTION_HAS_NOT_ENOUGH_RESOURCES_TO_CREATE_WEBSPACE = single_line_message("""
	Subscription #%d has not enough resources to create webspace '%s'. Following hostings are missing: %s
""")
INTERNAL_ERROR_MISSING_REQUEST_ID = single_line_message("""
	Internal error: a webspace was just created, but the corresponding request_id was not saved
""")
CHECK_TARGET_POA_API_CONNECTION = single_line_message("""
	Check target POA API connection
""")
FAILED_TO_CHECK_POA_API = multi_line_message("""
	Failed to check POA API at %s: %s. Make sure that PPA Public API is configured
	and there are no firewall rules that could block connections to it.
	Also the issue might be caused by incorrect PPA Public API configuration.
	Please verify settings at: "System" - "Settings" - "Public API":
	1. "SSL" should be enabled.
	2. "HTTP Authentication" should be enabled.
	3. "Accept connections" should have one of the values:
		1) "Only from allowed networks". In that case you should add host where you run
		migration/moving tools to allowed hosts at "Allowed Networks" tab.
		2) "From everywhere". No additional configuration is required in that case,
		still this option is not recommended due to security considerations.
""")
TRYING_TO_GET_RUNNER_FOR_EXTERNAL = single_line_message("""
	Trying to get runner for external database server. Running commands on external database server is not implemented.
""")
TRYING_TO_GET_OS_TYPE_FOR_EXT_DB = single_line_message("""
	Trying to get OS type for external database server. Getting OS type for external database server is not implemented.
""")
EXTERNAL_DATABASE_SERVER_IS_NOT_PPA_SN = single_line_message("""
	External database server is not a PPA service node, so we cannot get target server object for it.
""")
FAILED_CLEANUP_BACKUP_XML_FOR_PPA = single_line_message("""
	Failed to cleanup backup XML for PPA
""")
IT_IS_STRONGLY_RECOMMENDED_REVIEW_DNS_2 = single_line_message("""
	It is strongly recommended to review DNS zone records after migration.
	In general case changing CNAME to A record would solve the problem.
""")
MOST_PROBABLY_IT_IS_NOT_PROBLEM_1 = single_line_message("""
	Most probably it is not a problem, but it is recommended to review DNS zone records after migration
""")
DUPLICATE_DNS_RECORD_R_NOT_ADDED = single_line_message("""
	Duplicate DNS record %r will not be added again'
""")
CUSTOM_RECORD_MIGRATED_AS_IS = single_line_message("""
	Custom record '%s' refers to one of source Plesk IP addresses,
	but the IP does not match source subscriptions's service IPs.
	The record was migrated as is
""")
CUSTOM_RECORD_S_REFERS_ONE_HOST = single_line_message("""
	Custom record (%s) refers to one of host IP addresses and could break operability of DNS. It was not migrated
""")
SEEMS_THAT_DOMAIN_S_DISABLED_WEB = single_line_message("""
	Seems that domain '%s' has disabled web hosting, which makes Plesk not to put domain IP in backup.
	Run workaround - determine IP address by DNS records
""")
CONVERT_DNS_RECORDS_FOR_S_ZONE = single_line_message("""
	Convert DNS records for '%s' zone"
""")
MOST_PROBABLY_IT_IS_NOT_PROBLEM = single_line_message("""
	Most probably it is not a problem, but it is recommended to review DNS zone records after migration
""")
RECORDS_FROM_SOURCE_SERVER_WERE_MIGRATED = single_line_message("""
	DNS record(s) instantiated by PPA template (%s) conflict with record(s) from source server (%s).
	Records from source server were migrated, records instantiated by PPA template are not added to DNS zone
""")
CUSTOM_RECORD_OLD_RECORD_REFERS_ONE = single_line_message("""
	Custom record '{old_record}' refers to one of host IP addresses.
	The record was removed as corresponding service does not exist on target subscription
""")
DOMAIN_AXFR_RECORD_R_ALLOWING_EXTERNAL = single_line_message("""
	This domain has AXFR record (%r) allowing external DNS server(s) to transfer its zone.
	After transferring this domain to PPA, an external DNS server will still be able to transfer zone
	from Plesk server, but the zone transferred will not contain subdomains' records.
	The subdomains' records will be held in subdomains' own zones, and must be transferred with these zones.
	Allowing transfer of subdomain zones from Plesk server is not implemented in migration.
""")
IT_IS_STRONGLY_RECOMMENDED_REVIEW_DNS_1 = single_line_message("""
	It is strongly recommended to review DNS zone records after migration
""")
FAILED_ENCODE_NAME_S_IN_IDNA = single_line_message("""
	Failed to encode name '%s' in IDNA
""")
IT_IS_RECOMMENDED_REVIEW_DNS_ZONE = single_line_message("""
	It is recommended to review DNS zone records after migration
""")
STANDARD_DNS_RECORD_R_REMOVED = single_line_message("""
	The standard DNS record %r will be removed
""")
IT_IS_STRONGLY_RECOMMENDED_REVIEW_DNS = single_line_message("""
	It is strongly recommended to review DNS zone records after migration
""")
REMOVE_BAD_NS_RECORD_S_THAT = single_line_message("""
	Remove bad NS record '%s' that does not have corresponding A record
""")
CUSTOM_RECORD_REFERS_TO_SOURCE_IP_REMOVED = single_line_message("""
	Custom record '{old_record}' refers to one of source Plesk IP addresses,
	but the IP does not match source subscriptions's service IPs.
	Most probably this record is related to {service_name} service.
	The record was removed as service does not exist on target subscription
""")
CNAME_DNS_RECORD_WON_BE_MIGRATED_RFC1912 = single_line_message("""
	CNAME DNS record '%s' won't be migrated to PPA.
	DNS zone on target panel has an NS record with such source, but according to RFC 1912,
	CNAME record cannot coexist with other records with the same source
""")
CUSTOM_RECORD_REFERS_TO_SOURCE_IP_CHANGED = single_line_message("""
	Custom record '{old_record}' refers to one of source Plesk IP addresses,
	but the IP does not match source subscriptions's service IPs.
	Most probably this record is related to {service_name} service.
	The record was changed to point to subscription's {service_name} IP and migrated as {new_records}
""")
FAILED_CONVERT_DNS_RECORDS_FOR_SUBSCRIPTION_1 = single_line_message("""
	Failed to convert DNS records for subscription '%s'
""")
CUSTOM_CNAME_RECORD_OLD_RECORD_REFERS = single_line_message("""
	Custom CNAME record '{old_record}' refers to domain name.
	It is considered that the record is related to {service_name} service.
	The record was removed as the service does not exist on target subscription
""")
CONFIGURE_THOSE_EXTERNAL_DNS_SERVERS_TRANSFER = single_line_message("""
	Configure those external DNS server(s) to transfer the subdomains' zones from PPA DNS server(s).
""")
PPA_MAIN_NODE_LICENSE_MISSING_OR_INVALID = single_line_message("""
	PPA license is missing or invalid, please fix
""")
CHECK_PPA_MAIN_NODE_LICENSE = single_line_message("""
	Check PPA management node license
""")
FAILED_TO_CHECK_PPA_MAIN_NODE_LICENSE = single_line_message("""
	Failed to check PPA management node license
""")
NO_PLESK_LICENSE_AT_SERVICE_NODE = single_line_message("""
	There is no Plesk license at %s, please fix
""")
SERVICE_NODES_LICENSES_ARE_OK = single_line_message("""
	PPA service node licenses are ok
""")
MAIN_NODE_LICENSE_IS_OK = single_line_message("""
	PPA management node license is ok
""")
FAILED_TO_GET_INFO_ABOUT_PPA_MAIN_KEY = single_line_message("""
	Failed to get information about PPA main license key: %s.
	PPA service node license pre-migration checks will be skipped.
""")
CHECK_PPA_SERVICE_NODES_LICENSES = single_line_message("""
	Check licenses of PPA service nodes
""")
FAILED_TO_CHECK_PPA_SERVICE_NODES_LICENSES = single_line_message("""
	Failed to check licenses of PPA service nodes
""")

CANNOT_CREATE_AUXILIARY_USERS_FOR_CLIENT = single_line_message("""
	Cannot create auxiliary users for client without subscriptions.'
""")
SUBSCRIPTION_NO_WEB_IP_ADDRESSES_SKIP = single_line_message("""
	Subscription has no web IP addresses, skip cleaning up its vhost
""")
PPA_HOST_ID_WHERE_SUBSCRIPTIONS_WEB = single_line_message("""
	PPA host id where subscriptions web service is located: %s
""")
FAILED_CREATE_CLIENT_IN_S = single_line_message("""
	Failed to create client in %s.
""")
FAILED_CREATE_SUBSCRIPTION_IN_S = single_line_message("""
	Failed to create subscription in %s.
""")
WAIT_UNTIL_ALL_CLIENTS_ARE_CREATED = single_line_message("""
	Wait until all clients are created in Plesk
""")
FAILED_UPDATE_AUXILIARY_USER_ROLE_PLESK = single_line_message("""
	Failed to update auxiliary user role with Plesk API.
""")
FAILED_CLEAN_UP_SKELETON_WEBSPACE = single_line_message("""
	Failed to clean up skeleton of webspace.
""")
CREATE_AUXILIARY_USERS_FOR_S_CUSTOMER = single_line_message("""
	Create auxiliary users for '%s' customer
""")
TIMED_OUT_WAITING_UNTIL_WEBSPACE_S = single_line_message("""
	Timed out waiting until webspace %s is provisioned
""")
PROVISIONING_WEBSPACE_S_IS_TIMED_OUT = single_line_message("""
	Provisioning of the webspace %s is timed out.
""")
FAILED_GET_HOSTING_TYPE_SUBSCRIPTION_S = single_line_message("""
	Failed to get hosting type of subscription %s: expected to have exactly 1 result to Plesk API request, got %s
""")
TIME_OUT_WAITING_FOR_PROVISIONING_CUSTOMERS = single_line_message("""
	Time out: waiting for provisioning of customers, %d out of %d customer(s) were not provisioned to Plesk
""")
FAILED_CREATE_AUXILIARY_ROLES_CLIENT = single_line_message("""
	Failed to create auxiliary roles of client.
""")
SKIP_AUXILIARY_USER_S_AS_IT = single_line_message("""
	Skip auxiliary user '%s' as it already exists on target panel
""")
SKIP_AUXILIARY_USER_ROLE_S_AS = single_line_message("""
	Skip auxiliary user role '%s' as it already exists on target panel
""")
FAILED_CREATE_AUXILIARY_USER_ROLE_PLESK = single_line_message("""
	Failed to create auxiliary user role with Plesk API.
""")
FAILED_CREATE_AUXILIARY_USER_IN_PLESK = single_line_message("""
	Failed to create auxiliary user in Plesk.
""")
HELP_PPA_COMPLETE_TASKS_FOR_WEBSPACE = single_line_message("""
	Help PPA to complete the tasks for this webspace successfully,
	then - only if you transfer subscription to a new server - clean up webspace's virtual host:
	remove all files from its httpdocs/ and cgi-bin/ directories, and then retry the migration of this subscription.
""")
FAILED_CREATE_AUXILIARY_USERS_CLIENT = single_line_message("""
	Failed to create auxiliary users of client.
""")
ALL_CLIENTS_ARE_PROVISIONED_PLESK = single_line_message("""
	All clients are provisioned to Plesk
""")
FAILED_CREATE_WEBSPACE_IN_S = single_line_message("""
	Failed to create webspace in %s.
""")
SOME_ERROR_OCCURED_DURING_FETCHING_LIST = single_line_message("""
	Some error occured during fetching list of provisioned clients. See log for Plesk response details.
""")
CLIENT_S_ALREADY_EXISTS_IN_PPA = single_line_message("""
	Client '%s' already exists on target panel
""")
SUBSCRIPTION_S_USER_S_IS_RESTRICTED = single_line_message("""
	Subscription '%s' user '%s' is restricted to does not exist. User won't be created.
""")
ERROR_WHILE_FETCHING_SUBSCRIPTION_WEB_SERVICE = single_line_message("""
	Error while fetching subscription web service IP from Plesk:
	expected to receive exactly one subscription, Plesk API returned %d subscriptions.
""")
SUBSCRIPTION_S_ALREADY_EXISTS_IN_PPA = single_line_message("""
	Subscription '%s' already exists on target panel
""")
SUBSCRIPTION_DOES_NOT_HAVE_VIRTUAL_HOSTING = single_line_message("""
	Subscription does not have virtual hosting, skip cleaning up its vhost
""")
SUBSCRIPTION_S_USER_S_IS_RESTRICTED_1 = single_line_message("""
	Subscription '%s' user '%s' is restricted to is not active (not provisioned, or suspended). User won't be created.
""")
PPA_WEBSPACE_CORRESPONDING_SUBSCRIPTION_S_DIFFERENT = single_line_message("""
	PPA webspace corresponding to subscription '%s' has different owner
""")
WAITING_FOR_WEBSPACE_PROVISIONING = single_line_message("""
	Waiting for webspace provisioning
""")
WAITING_FOR_CLIENT_PROVISIONING = single_line_message("""
	Waiting for client provisioning
""")
CUSTOMER_ACCOUNT_LOGIN_S_MUST_EXIST = single_line_message("""
	Customer account with login '%s' must exist in PPA, but it does not exist.
""")
FAILED_CREATE_AUXILIARY_USER_ROLE_PLESK_1 = single_line_message("""
	Failed to create auxiliary user role with Plesk API.
""")
UPDATING_ROLES_PRECREATED_BY_PLESK_BUT = single_line_message("""
	Updating roles pre-created by Plesk but not built-in
""")
CLEAN_UP_SUBSCRIPTIONS_VHOST_FILES = single_line_message("""
	Clean up subscriptions vhost files
""")
TIME_OUT_WAITING_FOR_PROVISIONING_CUSTOMER = single_line_message("""
	Time out: waiting for provisioning customer to Plesk
""")
CREATE_WEBSPACE_S_IN_SUBSCRIPTION_S = single_line_message("""
	Create webspace '%s' in subscription #%s
""")

HOST_ID_FOR_IP_S_NOT = single_line_message("""
	Host ID for IP '%s' not found, is it registered in PPA?
""")
DUMPING_FULL_HCL_IN_LOG_IS = single_line_message("""
	Dumping full HCL in log is skipped, reduced HCL will be logged
""")
WEBSPACE_ID_SPECIFIED_BY_WEBSPACEID_OPTION = single_line_message("""
	Webspace ID specified by '--webspace-id' option should be valid integer
""")
WEBSPACE_REMOVE_SCHEDULED_PLEASE_CHECK_PPA = single_line_message("""
	Webspace remove has been scheduled. Please check PPA task manager and wait till all related tasks are complete
""")
REMOVE_WEBSPACE_FROM_PPA = single_line_message("""
	Remove webspace from PPA
""")
FAILED_TO_REMOVE_WEBSPACE_FROM_PPA = single_line_message("""
	Failed to remove webspace from PPA
""")
COMMAND_COMMAND_EXECUTED_AT_HOST_RETURNED = multi_line_message("""
	The command "{command}" executed at {host} returned a non-zero exit code.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	1. If this happened because of a network issue, re-run the migration tool.
	2. To investigate the issue, execute an HCL request and look at the result:
	2.1. Log in to the PPA management node.
	2.2. Create an XML file with an HCL request (/tmp/tmp-hcl for example):
	{hcl_script}
	2.3. Run the command:
	/usr/local/pem/bin/pleskd_ctl -f /usr/local/pem/etc/pleskd.props processHCL /tmp/tmp-hcl {host_id}
""")
RUNNER_DOES_NOT_SUPPORT_STDIN_CONTENT = single_line_message("""
	This runner does not support stdin_content parameter
""")
COMMAND_COMMAND_EXECUTED_AT_HOST_RETURNED_1 = multi_line_message("""
	The command "{command}" executed at {host} returned a non-zero exit code.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	1. If this happened because of a network issue, re-run the migration tool.
	2. To investigate the issue, execute an HCL request and look at the result:
	2.1. Log in to the PPA management node.
	2.2. Create an XML file with an HCL request (/tmp/tmp-hcl for example):
	{hcl_script}
	2.3. Run the command:
	/usr/local/pem/bin/pleskd_ctl -f /usr/local/pem/etc/pleskd.props processHCL /tmp/tmp-hcl {host_id}
""")
FAILED_EXECUTE_COMMAND_COMMAND_AT_HOST = multi_line_message("""
	Failed to execute the command "{command}" at {host}:
	pleskd_ctl returned a non-zero exit code when executing HCL request.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	1. If this happened because of a network issue, re-run the migration tool.
	2. To investigate the issue, execute an HCL request and look at the result:
	2.1. Log in to the PPA management node.
	2.2. Create an XML file with an HCL request (/tmp/tmp-hcl for example):
	{hcl_script}
	2.3. Run the command:
	"/usr/local/pem/bin/pleskd_ctl -f /usr/local/pem/etc/pleskd.props processHCL /tmp/tmp-hcl {host_id}"
""")
FAILED_DETECT_OS_NODE_COMMAND_COMMAND = multi_line_message("""
	Failed to detect OS of the node.
	The command "{command}" executed at {host_description} returned a non-zero exit code.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	1. If this happened because of a network issue, re-run the migration tool.
	2. To investigate the issue, execute an HCL request and look at the result:
	2.1. Log in to the PPA management node.
	2.2. Create an XML file with an HCL request (/tmp/tmp-hcl for example):
	{hcl_script}
	2.3. Run the command:
	"/usr/local/pem/bin/pleskd_ctl -f /usr/local/pem/etc/pleskd.props processHCL /tmp/tmp-hcl {host_id}"
	2.4. If node OS is Windows, expect error message '{windows_pattern}', otherwise expect no error messages
""")
FAILED_DETECT_OS_NODE_COMMAND_COMMAND_1 = multi_line_message("""
	Failed to detect OS of the node.
	The command "{command}" executed at {host_description} returned a non-zero exit code.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	1. If this happened because of a network issue, re-run the migration tool.
	2. To investigate the issue, execute an HCL request and look at the result:
	2.1. Log in to the PPA management node.
	2.2. Create an XML file with an HCL request (/tmp/tmp-hcl for example):
	{hcl_script}
	2.3. Run the command:
	"/usr/local/pem/bin/pleskd_ctl -f /usr/local/pem/etc/pleskd.props processHCL /tmp/tmp-hcl {host_id}"
	2.4. If node OS is Windows, expect error message '{windows_pattern}', otherwise expect no error messages
""")
PPA_API_DOES_NOT_WORK_OVER = single_line_message("""
	PPA API does not work over IPv6, so please change IPv6 (%s) to IPv4 in config file in PPA's section
""")
SUBSCRIPTION_SOME_MAIL_LISTS_MAIL_LISTS = single_line_message("""
	Subscription has some mail list(s). Mail lists are not supported by PPA.
""")
FAILED_CHECK_FOR_MAILLISTS_FOR_SUBSCRIPTION = single_line_message("""
	Failed to check for maillists for subscription '%s'
""")
CHECK_CATCHALL_REDIRECTS_ANOTHER_SERVER = single_line_message("""
	Check catch-all redirects to another server
""")
ALL_MAIL_THAT_IS_SENT_NONEXISTENT = single_line_message("""
	All mail that is sent to nonexistent users will be rejected by PPA mail server.
""")
SOURCE_SERVER_ALL_MAIL_THAT_WAS = single_line_message("""
	On the source server, all mail that was sent to nonexistent mail users was redirected to external mail server '%s'.
	PPA does not support such option.
""")
FAILED_CHECK_CATCH_ALL_REDIRECTS_FOR = single_line_message("""
	Failed to check catch all redirects for subscription '%s'
""")
WEBMAIL_IP_ADDRESS_INVALID = single_line_message("""
	Webmail IP address '%s' specified in 'webmail-ip' option of '[ppa]' is not valid IP v4.
	Please specify valid IP v4 address.
""")
WEBMAIL_IP_ADDRESS_NOT_SPECIFIED = single_line_message("""
	Webmail IP address is not specified in '[ppa]' section of configuration file.
	Please specify valid IP v4 address.
""")
CANNOT_FIND_TARGET_IP_FOR_SUBSTITUTION = single_line_message("""
	Cannot find a target IP for substitution in the subscription '{subscription_name}'
""")
CHANGE_NO_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
	Change web IP addresses in backup for subscription without virtual hosting
""")
FAILED_TO_CHANGE_NO_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
	Failed to change web IP addresses in backup for subscription without virtual hosting
""")
LOG_WEB_IPS_SET_TO = single_line_message("""
	Subscription '{subscription_name}' web IPs are set to ({ipv4}, {ipv6})
""")
PPA_WEBSPACE_INCONSISTENCY = multi_line_message("""
	There is inconsistency in PPA: webspace '{webspace_name}' ({webspace_id}) doesn't have corresponding subscription.
	The inconsistency must be fixed before migration.
	If you don't need that webspace in PPA and want to replace it with webspace from source panel
	run '{util_name} remove-webspace config.ini --webspace-id {webspace_id}' command
	to clean up hung webspace from PPA.
""")
FIX_INCONSISTENCIES_LISTED_ABOVE_AND_RERUN_MIGRATION = single_line_message("""
	Fix the inconsistencies listed above and re-run migration tool when all of them are fixed
""")
SUBSCRIPTION_DOES_NOT_EXIST_ON_TARGET_PPA = single_line_message("""
	Subscription does not exist on target PPA or was not provisioned.
	All transfer operations for that subscription will be skipped.
	Check PPA task manager for failed tasks.
""")
RUN_HCL_DETAILS = single_line_message("""
	Process following HCL on host #%d:\n%s
""")
GET_PPA_PLATFORM_VERSION = single_line_message("""
	Get PPA platform version.
""")
RAW_PPA_PLATFORM_VERSION = single_line_message("""
	Raw PPA platform version: %s'
""")
FAILED_GET_PPA_PLATFORM_VERSION = single_line_message("""
	Unable to determine PPA platform version.
""")
DEFAULT_PPA_HOST_DESCRIPTION = single_line_message("""
	PPA service node #%s
""")
ACTION_CHECK_MAILLISTS = single_line_message("""
	Check maillists
""")
MAIL_LISTS_WONT_BE_MIGRATED = single_line_message("""
	Mail lists won't be migrated.
""")
ACTION_CLEANUP_XML = single_line_message("""
	Cleanup backup XML for PPA
""")
ACTION_CONVERT_DNS_RECORDS = single_line_message("""
	Convert DNS records
""")
DEBUG_SOURCE_DNS_ZONE_TEMPALTE = single_line_message("""
	Source DNS zone template: %r
""")
DEBUG_REMOVE_DNS_RECORD_FROM_ALIAS_ZONE = single_line_message("""
	Remove a record from '%s' alias ('%s' domain) zone: '%s'
""")
DEBUG_ADD_SUBDOM_RECORD_TO_ALIAS_ZONE = single_line_message("""
	Add '%s' subdomain's record to '%s' alias zone: '%s'
""")
DEBUG_DNS_RECORD_GENERATED = single_line_message("""
	DNS record %r is generated by template record (src='%s', dst='%s')
""")
CUSTOM_RECORD_REPLACED = single_line_message("""
	Custom record '{old_record}' refers to one of host IP addresses.
	The record was changed to point to subscription's {service_name} IP and migrated as {new_records}
""")
CUSTOM_CNAME_RECORD_ISSUE = single_line_message("""
	Custom CNAME record '{old_record}' refers to domain name. This can make {service_name} service to work incorrectly.
	The record was changed and migrated as {new_records}
""")
ACTION_REMOVE_MAILLISTS_FROM_BACKUP = single_line_message("""
	Remove maillists from backup
""")
FAILED_REMOVE_MAILLISTS_FOR_SUBSCRIPTION_S = single_line_message("""
	Failed to remove maillists from backup for subscription '%s'
""")
LOG_EXCEPTION = single_line_message("""
	Exception:
""")
DEBUG_PPA_LICENSING_SCHEMA = single_line_message("""
	PPA licensing schema is: %s
""")
LOG_PPA_MN = single_line_message("""
	PPA management node: %s
""")
LOG_PPA_PLESK_URL = single_line_message("""
	PPA Plesk URL: %s
""")
PPA_MN_DESCRIPTION = single_line_message("""
	PPA management node
""")
UNKNOWN_IP = single_line_message("""
	unknown IP
""")
PPA_SN_DESCRIPTION = single_line_message("""
	PPA service node '%s' (#%s, %s)
""")
NOT_ENOUGH_RESOURCES_SOLUTION = single_line_message("""
	You can do either of the following: (1) disable the allocation of optional resources by passing
	the --allocate-only-required-resources option to the migration tool;
	(2) adjust subscription's limits on the hosting types: ({hostings_lacking})
	and re-transfer this subscription; or (3) transfer this subscription in the single-webspace mode.
""")
LOG_CONVERT_SERVICE_TEMPLATES = single_line_message("""
	Convert service templates
""")
RESELLER_TITLE = single_line_message("""
	reseller '%s'
""")
ADMIN_TITLE = single_line_message("""
	admin
""")
SOLUTION_TRANSFER_MANUALLY = single_line_message("""
	Transfer this info manually.
""")
DEBUG_CONVERT_AUX_USER_ROLES = single_line_message("""
	Convert auxiliary user roles
""")
DEBUG_CONVERT_AUX_USERS = single_line_message("""
	Convert auxiliary users
""")
DEBUG_CONVERT_AUX_USER = single_line_message("""
	Convert auxiliary user '%s'
""")
DEBUG_CHECK_DNS_STATUS = single_line_message("""
	Check DNS status for '%s' zone (type: '%s', is_enabled: '%s')
""")
DEBUG_FETCH_DNS_TEMPLATE = single_line_message("""
	Fetch DNS template from PPA
""")
COMMAND_EXECUTED_AFTER_ATTEMPTS = single_line_message("""
	Command "{command}" was executed successfully at {host} after {attempts} attempt(s).
""")
COMMAND_EXECUTION_RETRY = single_line_message("""
	Failed to execute remote command, retry in {interval_between_attempts} seconds
""")
SLEEP_RETRY_COMMAND_EXECUTION = single_line_message("""
""")
LOG_COMMAND_FAILED = single_line_message("""
	Command '%s' failed with '%s' exit code, output: '%s', stderr: '%s'.
""")
FAILED_TO_EXECUTE_COMMAND_DESCRIPTION = multi_line_message("""
	Failed to execute the command "{command}" at {host}.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	1. If this happened because of a network issue, re-run the migration tool.
	2. To investigate the issue, execute an HCL request and look at the result:
	2.1. Log in to the PPA management node.
	2.2. Create an XML file with an HCL request (/tmp/tmp-hcl for example):
	{hcl_script}
	2.3. Run the command:
	/usr/local/pem/bin/pleskd_ctl -f /usr/local/pem/etc/pleskd.props processHCL /tmp/tmp-hcl {host_id}
""")
COMMAND_RETURNED_NON_ZERO_EXIT_CODE = single_line_message("""
	The command "{log_command}" executed at {host} returned a non-zero exit code.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	1. If this happened because of a network issue, re-run the migration tool.
	2. To investigate the issue, execute an HCL request and look at the result:
	2.1. Log in to the PPA management node.
	2.2. Create an XML file with an HCL request (/tmp/tmp-hcl for example):
	{hcl_script}
	2.3. Run the command
	/usr/local/pem/bin/pleskd_ctl -f /usr/local/pem/etc/pleskd.props processHCL /tmp/tmp-hcl {host_id}
""")
HELP_WEBSPACE_ID_TO_REMOVE = single_line_message("""
	Webspace ID to remove
""")
COMMAND_REMOVE_WEBSPACE = single_line_message("""
	Remove webspace from PPA
""")
LOG_CREATE_SUBSCRIPTION = single_line_message("""
	Create subscription '%s'%s for customer '%s'
""")
DEBUG_CLIENTS_PROVISIONED = single_line_message("""
	Following %d clients are provisioned: %r
""")
WEBSPACE_PROVISIONING_FAILED = single_line_message("""
	Provisioning of the webspace %s is failed: %s
""")
DEBUG_CREATING_ROLES = single_line_message("""
	Creating new roles
""")
DEBUG_SUBSCRIPTION_WEB_IPS = single_line_message("""
	Subscription web IPs: %r
""")
LOG_CREATE_CLIENT = single_line_message("""
	Create client '%s'
""")