from parallels.core.actions.content.mail.copy_content import CopyMailContent
from parallels.core.content.mail.imapsync import CopyMailImapsync


class CopyMailContentFromHelm3ToPPA(CopyMailContent):
	def _copy_mail_content_single_subscription(self, global_context, subscription, issues):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:type issues: list
		"""
		# Use slow imapsync which able to work with practically
		# any kind of mail server, and could transfer mail from Windows
		# mail server to Unix mail server
		copy_mail = CopyMailImapsync(imap_supported=True)
		copy_mail.copy_mail(global_context, global_context.migrator_server, subscription, issues)