from parallels.core.actions.base.legacy_action \
	import LegacyAction
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.ppa.source.helm4 import messages

from parallels.ppa.source.helm4.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS
from parallels.ppa.source.helm4.actions.content.web.copy_windows_content \
	import CopyWindowsWebContent
from parallels.plesk.source.plesk.actions.content.web.reset_permissions \
	import ResetPermissions
from parallels.ppa.source.helm4.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.ppa.source.helm4.actions.hosting_settings.transfer_mime_types \
	import TransferMIMETypes
from parallels.ppa.source.helm4.actions.hosting_settings.transfer_error_documents \
	import TransferErrorDocuments


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		workflow.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description=messages.ACTION_FETCH_SOURCE,
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)
		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-files', CopyWindowsWebContent()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'reset-permissions', ResetPermissions()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-error-documents', TransferErrorDocuments()
		)
