from collections import namedtuple
from parallels.core.utils.common import obj
from parallels.core.utils.yaml_utils import pretty_yaml

SSLProducts = obj(
	INSTANT='instant',
	INSTANT_PRO='instant-pro',
	PREMIUMO='premiumo',
	ELITE='elite',
	GOLD='gold',
	PLATINUM='platinum',
	POSITIVE='positive'
)

Model = pretty_yaml(namedtuple('Model', ('accounts')))

Account = pretty_yaml(namedtuple('Account', (
	'login', 
	'balance', 
	'credit_cards', # list of CreditCard objects
	'hosting_subscriptions', # list of HostingSubscription objects
	'domain_subscriptions', # list of DomainSubscription objects
	'ssl_subscriptions', # list of SSLSubscription objects
)))

CreditCard = pretty_yaml(namedtuple('CreditCard', (
	# 1) Credit card information
	'pay_system', # Str(30), one of PaySystem value
	'card_number', # Str(20)
	'card_holder_name', # Str(40)
	'cvv', # Str(4)
	'expiration_date', # Str(5), format: "DD/YY"
	'start_date', # Str(5), applicable for Maestro cards only, format: "DD/YY"
	'issue_number', # Str(4), applicable for Maestro cards only

	# 2) Contact information
	'address1', # Str(80)
	'address2', # Str(80)
	'city', # Str(40)
	'state', # Str(80)
	'zip_code', # Str(10)
	'country', # Str(2), 2-symbol identifier, in lower case, for example 'us' or 'ru'
	'email', # Str(100)
	'phone', # instance of PhoneNumber
	'fax', # instance of PhoneNumber

	# 3) Billing configuration
	'use_for_auto_payments', # Int
)))

PhoneNumber = pretty_yaml(namedtuple('PhoneNumber', (
	'country_code', # Str(4)
	'area_code', # Str(10)
	'number', # Str(20)
	'extension', # Str(10)
)))

PaySystem = obj(
	MASTER_CARD='MasterCard',
	VISA='Visa',
	DIRECT_DEBIT='DirectDebit',
	CHECK_OR_CACHE='Check/Cash',
	AMERICAN_EXPRESS='American Express',
	DINERS_CLUB='Diners Club',
	JCB='JCB',
	MAESTRO='Maestro',
	VISA_DEBIT='Visa Debit',
	DISCOVER='Discover',
	BANK_GIRO='BankGiro/PostGiro',
	PAY_PAL='PayPal',
	WORLD_PAY_REDIRECT='WorldPayRedirect',
	VISA_PURCHASING='Visa Purchasing',
	VISA_ELECTRON='Visa Electron',
	WORLD_PAY_PSEUDO_TOOL='WorldPayPseudoTool',
)

HostingSubscription = pretty_yaml(namedtuple('HostingSubscription', (
	'name',
	'billing_period', # instance of BillingPeriod
	'last_bill_date', # timestamp integer
	'next_bill_date' # timestamp integer
)))

SSLSubscription = pretty_yaml(namedtuple('SSLSubscription', (
	'domain_name',
	# certificate information
	'pkey',
	'certificate',
	'approver_email',
	'address1',
	'address2',
	'postal_code',

	# billing information
	'product',
	'period',
	'last_bill_date',

	# the below certificate information is extracted from the certificate
	'csr',
	'csr_attrs',	# C=AF, ST=NA, L=test, O=signup, OU=Not specified, CN=razdvatri.ru/emailAddress=bill@mailinator.com
	'start_date',
	'expiration_date',
)))

DomainSubscription = pretty_yaml(namedtuple('DomainSubscription', (
	'name',
	'subscription_period', # subscription period in years
	'start_date', # timestamp integer
	'last_bill_date', # timestamp integer
	'next_bill_date', # timestamp integer
	'users', # instance of DomainSubscriptionUsers
	'nameservers', # list of hostnames of name servers
	'registrar', # 'enom' or 'opensrs'
	'extra', # extra parameters, tld-specific, as they are in H-Sphere. conversion of them to PPAB API parameters requires knowledge of target registrar
)))

DomainSubscriptionUsers = pretty_yaml(namedtuple('DomainSubscriptionUsers', (
	'owner', # instance of DomainSubscriptionUser
	'admin', # instance of DomainSubscriptionUser
	'billing', # instance of DomainSubscriptionUser
	'tech', # instance of DomainSubscriptionUser
)))

DomainSubscriptionUser = pretty_yaml(namedtuple('DomainSubscriptionUser', (
	'first_name',
	'last_name',
	'email',
	'address1',
	'address2',
	'city',
	'state',
	'zip_code',
	'country',
	'phone', # instance of PhoneNumber
	'fax', # instance of PhoneNumber
)))

BillingPeriod = pretty_yaml(namedtuple('BillingPeriod', (
	'type', # one of BillingPeriodType value
	'size'
)))

BillingPeriodType = obj(
	DAY='day',
	MONTH='month',
	YEAR='year',
)

