from parallels.core import checking
from parallels.core.client_subscription_converter import ClientSubscriptionConverterAdapter
from parallels.core.utils.yaml_utils import read_yaml
from parallels.ppa.converter.converter import PPAConverter
from parallels.ppa.source.hsphere.converter import HSphereEntityConverter


class HSphereToPPAClientSubscriptionConverterAdapter(ClientSubscriptionConverterAdapter):
	def convert(self, global_context, converted_resellers, report):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		domain_os_type = read_yaml(global_context.migrator._get_session_file_path('domain_os_type.yaml'))
		contact_information = read_yaml(global_context.migrator._get_session_file_path('contact_information.yaml'))
		entity_converter = HSphereEntityConverter(
			global_context.target_existing_objects, domain_os_type, contact_information
		)
		converter = PPAConverter(
			global_context.conn.target.panel_admin_password, global_context.target_existing_objects,
			global_context.options, global_context.migrator.multiple_webspaces, entity_converter
		)
		plain_report = checking.PlainReport(report, *global_context.migrator._extract_source_objects_info())
		converter.convert_dumps(
			global_context.get_source_servers_info(), plain_report,
			global_context.migration_list_data.subscriptions_mapping,
			global_context.migration_list_data.customers_mapping,
			converted_resellers, global_context.password_holder
		)
		converter.fix_emails_of_aux_users()
		return converter.get_target_model()
