from parallels.core.utils.message_utils import single_line_message
from parallels.core.utils.message_utils import multi_line_message

LOG_EXCEPTION = single_line_message("""
	Exception:
""")
FAILED_TO_CALL_PPA_PUBLIC_API_METHOD = multi_line_message("""
	Failed to call PPA Public API method: %s. 
	Most probably the issue is caused by incorrect PPA Public API configuration.
	Please verify settings at: "System" - "Settings" - "Public API":
	1. "SSL" should be enabled.
	2. "HTTP Authentication" should be enabled.
	3. "Accept connections" should have one of the values:
		1) "Only from allowed networks".
		In that case you should add host where you run migration/moving
		tools to allowed hosts at "Allowed Networks" tab.
		2) "From everywhere".
		No additional configuration is required in that case,
		still this option is not recommended due to security considerations.
""")
ONLY_HTTP_AND_HTTPS_PROTOCOLS_ARE_SUPPORTED = single_line_message("""
	Only http and https protocols are supported by xmlrpclib
""")
HOW_TO_REPRODUCE_FAILED_REQUEST = multi_line_message("""
	An internal error occurred in POA XML-RPC: {error_message}
	If you referring to a technical support representative,
	please attach a stack trace with the error message from panel-migrator.debug.log.
	To execute a POA XML-RPC request manually:
	1. Open panel-migrator.debug.log, copy the POA XML-RPC request from the end of the file.
	2. Paste it into a new file, for example 'tmp/xmlrpc-packet'.
	3. Execute the request with the help of the command:
		curl https://<management_node_ip>:8440/RPC2 -uadmin:<password> -s -k -d @/tmp/xmlrpc-packet
	Replace <management_node_ip> and <password> with the appropriate IP address and password.
""")