param(
	[string]$basePath
)

[xml]$xmlDoc = New-Object system.Xml.XmlDocument
$xmlDoc.LoadXml("<?xml version=`"1.0`" encoding=`"utf-8`"?><owners></owners>")

$files = Get-ChildItem $basePath -Recurse

foreach ($file in $files) {
	$acl = Get-Acl $file.FullName

 	$filename = $file.FullName.Substring($basePath.length + 1)
	$owner = $acl.owner.split("\\")[1]
    
	$xmlElemFile = $xmlDoc.CreateElement("file")
	$xmlDoc.LastChild.AppendChild($xmlElemFile) > $null
	$xmlElemFilePath = $xmlDoc.CreateElement("path")
	$xmlElemFile.AppendChild($xmlElemFilePath) > $null
	$xmlElemFilePathText = $xmlDoc.CreateTextNode($filename)
	$xmlElemFilePath.AppendChild($xmlElemFilePathText) > $null
	$xmlElemFileOwner = $xmlDoc.CreateElement("owner")
	$xmlElemFile.AppendChild($xmlElemFileOwner) > $null
	$xmlElemFileOwnerText = $xmlDoc.CreateTextNode($owner)
	$xmlElemFileOwner.AppendChild($xmlElemFileOwnerText) > $null
}
                                                                  
Write-Host $xmlDoc.InnerXml

