"""Model representing objects that already exist in target panel"""

from collections import namedtuple
from parallels.core.utils.yaml_utils import pretty_yaml

PVPSExistingObjectsModel = pretty_yaml(
	namedtuple('PVPSExistingObjectsModel', (
		'resellers', 'customers', 'vps_service_templates', 'vps_subscriptions'
	)), 
	prefix='target-pvps'
)

PVPSServiceTemplate = pretty_yaml(
	namedtuple('PVPSServiceTemplate', (
		'id', 'name', 'owner_id', 'resource_types'
	)),
	prefix='target-pvps'
)

PVPSSubscription = pretty_yaml(
	namedtuple('PVPSSubscription', (
		'id', 'name', 'owner_id', 'plan_id'
	)),
	prefix='target-pvps'
)

PVPSResource = pretty_yaml(
	namedtuple('PVPSResources', (
		'rt_id', 'name', 'resclass_name', 'limit', 'act_params'
	)),
	prefix='target-pvps'
)
